/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.writer;

import cds.savot.model.CoosysSet;
import cds.savot.model.FieldRefSet;
import cds.savot.model.FieldSet;
import cds.savot.model.GroupSet;
import cds.savot.model.InfoSet;
import cds.savot.model.LinkSet;
import cds.savot.model.OptionSet;
import cds.savot.model.ParamRefSet;
import cds.savot.model.ParamSet;
import cds.savot.model.ResourceSet;
import cds.savot.model.SavotBinary;
import cds.savot.model.SavotCoosys;
import cds.savot.model.SavotData;
import cds.savot.model.SavotField;
import cds.savot.model.SavotFieldRef;
import cds.savot.model.SavotFits;
import cds.savot.model.SavotGroup;
import cds.savot.model.SavotInfo;
import cds.savot.model.SavotLink;
import cds.savot.model.SavotMax;
import cds.savot.model.SavotMin;
import cds.savot.model.SavotOption;
import cds.savot.model.SavotParam;
import cds.savot.model.SavotParamRef;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotStream;
import cds.savot.model.SavotTD;
import cds.savot.model.SavotTR;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotTableData;
import cds.savot.model.SavotVOTable;
import cds.savot.model.SavotValues;
import cds.savot.model.TRSet;
import cds.savot.model.TableSet;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;

public final class SavotWriter {
    private static final String tdempty = "<TD/>";
    private static final String tdbegin = "<TD>";
    private static final String tdend = "</TD>";
    private static final String trbegin = "<TR>";
    private static final String trend = "</TR>\n";
    private static final String tabledatabegin = "\n<TABLEDATA>\n";
    private static final String tabledataend = "</TABLEDATA>";
    private static final String databegin = "\n<DATA>";
    private static final String dataend = "\n</DATA>";
    private static final String tableend = "\n</TABLE>";
    private static final String resourceend = "\n</RESOURCE>";
    private static final String descriptionbegin = "\n<DESCRIPTION>";
    private static final String descriptionend = "</DESCRIPTION>";
    private static final String groupend = "\n</GROUP>";
    private static final String definitionsbegin = "\n<DEFINITIONS>";
    private static final String definitionsend = "\n</DEFINITIONS>";
    private static final String paramend = "\n</PARAM>";
    private static final String fieldend = "\n</FIELD>";
    private static final String linkend = "</LINK>";
    private static final String valuesend = "\n</VALUES>";
    private static final String fitsend = "\n</FITS>";
    private static final String binarybegin = "\n<BINARY>";
    private static final String binaryend = "\n</BINARY>";
    private static final String coosysend = "</COOSYS>";
    private static final String streamend = "\n</STREAM>";
    private static final String minend = "</MIN>";
    private static final String maxend = "</MAX>";
    private static final String optionend = "\n</OPTION>";
    private String top1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private String styleSheet = "";
    private boolean attributeEntities = true;
    private boolean elementEntities = true;
    private Writer bw = null;
    private final Pattern patternAMP = Pattern.compile("&");
    private final Pattern patternQUOT = Pattern.compile("\"");
    private final Pattern patternLT = Pattern.compile("<");
    private final Pattern patternGT = Pattern.compile(">");

    public void setTop1(String top1) {
        this.top1 = top1;
    }

    public void setStyleSheet(String href) {
        this.styleSheet = href;
    }

    public void enableAttributeEntities(boolean entities) {
        this.attributeEntities = entities;
    }

    public void enableElementEntities(boolean entities) {
        this.elementEntities = entities;
    }

    public void enableEntities(boolean entities) {
        this.attributeEntities = entities;
        this.elementEntities = entities;
    }

    public String encodeAttribute(String src) {
        if (this.attributeEntities) {
            String out = this.patternAMP.matcher(src).replaceAll("&amp;");
            out = this.patternLT.matcher(out).replaceAll("&lt;");
            out = this.patternGT.matcher(out).replaceAll("&gt;");
            out = this.patternQUOT.matcher(out).replaceAll("&quot;");
            return out;
        }
        return src;
    }

    public String encodeElement(String src) {
        if (this.elementEntities) {
            String out = this.patternAMP.matcher(src).replaceAll("&amp;");
            out = this.patternLT.matcher(out).replaceAll("&lt;");
            out = this.patternGT.matcher(out).replaceAll("&gt;");
            return out;
        }
        return src;
    }

    public void generateDocument(SavotVOTable votable) throws IOException {
        this.generateDocument(votable, null, null);
    }

    public void generateDocument(SavotVOTable votable, OutputStream stream) throws IOException {
        this.generateDocument(votable, null, stream);
    }

    public void generateDocument(SavotVOTable votable, String file) throws IOException {
        this.generateDocument(votable, file, null);
    }

    public void generateDocument(SavotVOTable votable, String file, OutputStream stream) throws IOException {
        if (file != null) {
            this.initStream(file);
        } else if (stream != null) {
            this.initStream(stream);
        } else {
            this.initStream(new PrintWriter(System.out));
        }
        this.writeDocumentHead(votable);
        this.writeCoosys(votable.getCoosys());
        this.writeInfo(votable.getInfos());
        this.writeParam(votable.getParams());
        this.writeGroup(votable.getGroups());
        this.writeResource(votable.getResources());
        this.writeInfo(votable.getInfosAtEnd());
        this.writeDocumentEnd();
    }

    public void initStream(String file) throws IOException {
        boolean compressed = file.endsWith("gz");
        OutputStream outStream = this.getOutputStream(new FileOutputStream(file), compressed);
        this.initStream(new OutputStreamWriter(outStream));
    }

    public void initStream(OutputStream stream) throws IOException {
        OutputStream outStream = this.getOutputStream(stream, false);
        this.initStream(new OutputStreamWriter(outStream));
    }

    public void initStream(Writer writer) {
        this.bw = new BufferedWriter(writer, 65536);
    }

    private OutputStream getOutputStream(OutputStream outstream, boolean compressed) throws IOException {
        int bufferSize = 65536;
        FilterOutputStream out = compressed ? new GZIPOutputStream(outstream, 65536) : new BufferedOutputStream(outstream, 65536);
        return out;
    }

    public void writeComment(String comment) throws IOException {
        if (comment.length() != 0) {
            this.bw.append("\n<!-- ").append(comment).append(" -->\n");
        }
    }

    public void writeDescription(String description) throws IOException {
        if (description.length() != 0) {
            this.bw.append(descriptionbegin).append(this.encodeElement(description)).append(descriptionend);
        }
    }

    public void writeDocumentHead(SavotVOTable votable) throws IOException {
        Writer w = this.bw;
        w.write(this.top1);
        this.writeComment(votable.getAbove());
        if (this.styleSheet.length() != 0) {
            w.append("\n<?xml-stylesheet type=\"text/xsl\" href=\"").append(this.styleSheet).append("\" ?>");
        }
        w.write("\n<VOTABLE");
        if (votable.getXmlns().length() != 0 || votable.getXmlnsxsi().length() != 0 || votable.getXsischema().length() != 0 || votable.getXsinoschema().length() != 0) {
            if (votable.getXmlns().length() != 0) {
                w.append(" xmlns=\"").append(votable.getXmlns()).append('\"');
            }
            if (votable.getXmlnsxsi().length() != 0) {
                w.append(" xmlns:xsi=\"").append(votable.getXmlnsxsi()).append('\"');
            }
            if (votable.getXsischema().length() != 0) {
                w.append(" xsi:schemaLocation=\"").append(votable.getXsischema()).append('\"');
            }
            if (votable.getXsinoschema().length() != 0) {
                w.append(" xsi:noNamespaceSchemaLocation=\"").append(votable.getXsinoschema()).append('\"');
            }
        }
        w.write(" version=");
        if (votable.getVersion().length() != 0) {
            if (votable.getId().length() != 0) {
                w.append('\"').append(votable.getVersion()).append('\"').append(" ID=\"").append(votable.getId()).append('\"').append('>');
            } else {
                w.append('\"').append(votable.getVersion()).append('\"').append('>');
            }
        } else if (votable.getId().length() != 0) {
            w.append('\"').append("1.2").append('\"').append(" ID=\"").append(votable.getId()).append('\"').append('>');
        } else {
            w.append('\"').append("1.2").append('\"').append('>');
        }
        this.writeComment(votable.getBelow());
        this.writeDescription(votable.getDescription());
        if (votable.getDefinitions() != null) {
            w.write(definitionsbegin);
            this.writeCoosys(votable.getDefinitions().getCoosys());
            this.writeParam(votable.getDefinitions().getParams());
            w.write(definitionsend);
        }
        w.flush();
    }

    public void writeDocumentEnd() throws IOException {
        this.bw.write("\n</VOTABLE>\n");
        this.bw.flush();
        this.bw.close();
        this.bw = null;
    }

    public void writeCoosys(CoosysSet coosysSet) throws IOException {
        Writer w = this.bw;
        int len = coosysSet.getItemCount();
        for (int i = 0; i < len; ++i) {
            SavotCoosys coosys = (SavotCoosys)coosysSet.getItemAt(i);
            this.writeComment(coosys.getAbove());
            w.write("\n<COOSYS");
            if (coosys.getId().length() != 0) {
                w.append(" ID=\"").append(coosys.getId()).append('\"');
            }
            if (coosys.getEquinox().length() != 0) {
                w.append(" equinox=\"").append(coosys.getEquinox()).append('\"');
            }
            if (coosys.getEpoch().length() != 0) {
                w.append(" epoch=\"").append(coosys.getEpoch()).append('\"');
            }
            if (coosys.getSystem().length() != 0) {
                w.append(" system=\"").append(coosys.getSystem()).append('\"');
            }
            if (coosys.getContent().length() != 0) {
                w.write(">");
                this.writeComment(coosys.getBelow());
                w.write(coosys.getContent());
                w.write(coosysend);
                continue;
            }
            w.write("/>");
            this.writeComment(coosys.getBelow());
        }
    }

    public void writeParam(ParamSet params) throws IOException {
        if (params != null) {
            Writer w = this.bw;
            int len = params.getItemCount();
            for (int i = 0; i < len; ++i) {
                SavotParam param = (SavotParam)params.getItemAt(i);
                this.writeComment(param.getAbove());
                w.write("\n<PARAM");
                if (param.getName().length() != 0) {
                    w.append(" name=\"").append(this.encodeAttribute(param.getName())).append('\"');
                }
                if (param.getId().length() != 0) {
                    w.append(" ID=\"").append(this.encodeAttribute(param.getId())).append('\"');
                }
                if (param.getDataType().length() != 0) {
                    w.append(" datatype=\"").append(this.encodeAttribute(param.getDataType())).append('\"');
                }
                if (param.getArraySize().length() != 0) {
                    w.append(" arraysize=\"").append(this.encodeAttribute(param.getArraySize())).append('\"');
                }
                if (param.getPrecision().length() != 0) {
                    w.append(" precision=\"").append(this.encodeAttribute(param.getPrecision())).append('\"');
                }
                if (param.getWidth().length() != 0) {
                    w.append(" width=\"").append(this.encodeAttribute(param.getWidth())).append('\"');
                }
                if (param.getXtype().length() != 0) {
                    w.append(" xtype=\"").append(this.encodeAttribute(param.getXtype())).append('\"');
                }
                if (param.getRef().length() != 0) {
                    w.append(" ref=\"").append(this.encodeAttribute(param.getRef())).append('\"');
                }
                if (param.getUcd().length() != 0) {
                    w.append(" ucd=\"").append(this.encodeAttribute(param.getUcd())).append('\"');
                }
                if (param.getUtype().length() != 0) {
                    w.append(" utype=\"").append(this.encodeAttribute(param.getUtype())).append('\"');
                }
                w.append(" value=\"").append(this.encodeAttribute(param.getValue())).append('\"');
                if (param.getUnit().length() != 0) {
                    w.append(" unit=\"").append(this.encodeAttribute(param.getUnit())).append('\"');
                }
                if (param.getValues() != null || param.getLinks().getItemCount() != 0 || param.getDescription().length() != 0) {
                    w.write(">");
                    this.writeComment(param.getBelow());
                    this.writeDescription(param.getDescription());
                    this.writeValues(param.getValues());
                    this.writeLink(param.getLinks());
                    w.write(paramend);
                    continue;
                }
                w.write("/>");
                this.writeComment(param.getBelow());
            }
        }
    }

    public void writeParamRef(ParamRefSet refparams) throws IOException {
        if (refparams != null) {
            Writer w = this.bw;
            int len = refparams.getItemCount();
            for (int i = 0; i < len; ++i) {
                SavotParamRef paramref = (SavotParamRef)refparams.getItemAt(i);
                this.writeComment(paramref.getAbove());
                w.write("\n<PARAMref");
                if (paramref.getRef().length() != 0) {
                    w.append(" ref=\"").append(this.encodeAttribute(paramref.getRef())).append('\"');
                }
                if (paramref.getUcd().length() != 0) {
                    w.append(" ucd=\"").append(this.encodeAttribute(paramref.getUcd())).append('\"');
                }
                if (paramref.getUtype().length() != 0) {
                    w.append(" utype=\"").append(this.encodeAttribute(paramref.getUtype())).append('\"');
                }
                w.write("/>");
                this.writeComment(paramref.getBelow());
            }
        }
    }

    public void writeLink(LinkSet linkSet) throws IOException {
        Writer w = this.bw;
        int len = linkSet.getItemCount();
        for (int i = 0; i < len; ++i) {
            SavotLink link = (SavotLink)linkSet.getItemAt(i);
            this.writeComment(link.getAbove());
            w.write("\n<LINK");
            if (link.getId().length() != 0) {
                w.append(" ID=\"").append(this.encodeAttribute(link.getId())).append('\"');
            }
            if (link.getContentRole().length() != 0) {
                w.append(" content-role=\"").append(this.encodeAttribute(link.getContentRole())).append('\"');
            }
            if (link.getContentType().length() != 0) {
                w.append(" content-type=\"").append(this.encodeAttribute(link.getContentType())).append('\"');
            }
            if (link.getTitle().length() != 0) {
                w.append(" title=\"").append(this.encodeAttribute(link.getTitle())).append('\"');
            }
            if (link.getValue().length() != 0) {
                w.append(" value=\"").append(this.encodeAttribute(link.getValue())).append('\"');
            }
            if (link.getHref().length() != 0) {
                w.append(" href=\"").append(this.encodeAttribute(link.getHref()) + '\"');
            }
            if (link.getGref().length() != 0) {
                w.append(" gref=\"").append(this.encodeAttribute(link.getGref()) + '\"');
            }
            if (link.getAction().length() != 0) {
                w.append(" action=\"").append(this.encodeAttribute(link.getAction()) + '\"');
            }
            if (link.getContent().length() != 0) {
                w.write(">");
                this.writeComment(link.getBelow());
                w.write(link.getContent());
                w.write(linkend);
                continue;
            }
            w.write("/>");
            this.writeComment(link.getBelow());
        }
    }

    public void writeInfo(InfoSet infoSet) throws IOException {
        if (infoSet != null) {
            Writer w = this.bw;
            int len = infoSet.getItemCount();
            for (int i = 0; i < len; ++i) {
                SavotInfo info = (SavotInfo)infoSet.getItemAt(i);
                this.writeComment(info.getAbove());
                w.write("\n<INFO");
                if (info.getId().length() != 0) {
                    w.append(" ID=\"").append(this.encodeAttribute(info.getId())).append('\"');
                }
                if (info.getName().length() != 0) {
                    w.append(" name=\"").append(this.encodeAttribute(info.getName())).append('\"');
                }
                if (info.getValue().length() != 0) {
                    w.append(" value=\"").append(this.encodeAttribute(info.getValue())).append('\"');
                }
                if (info.getXtype().length() != 0) {
                    w.append(" xtype=\"").append(this.encodeAttribute(info.getXtype())).append('\"');
                }
                if (info.getRef().length() != 0) {
                    w.append(" ref=\"").append(this.encodeAttribute(info.getRef())).append('\"');
                }
                if (info.getUnit().length() != 0) {
                    w.append(" unit=\"").append(this.encodeAttribute(info.getUnit())).append('\"');
                }
                if (info.getUcd().length() != 0) {
                    w.append(" ucd=\"").append(this.encodeAttribute(info.getUcd())).append('\"');
                }
                if (info.getUtype().length() != 0) {
                    w.append(" utype=\"").append(this.encodeAttribute(info.getUtype())).append('\"');
                }
                if (info.getContent().length() != 0) {
                    w.write(">");
                    this.writeComment(info.getBelow());
                    w.append(this.encodeElement(info.getContent())).append("</INFO>");
                    continue;
                }
                if (info.getDescription().length() != 0 || info.getValues() != null || info.getLinks().getItemCount() != 0) {
                    w.write(">");
                    this.writeComment(info.getBelow());
                    this.writeDescription(info.getDescription());
                    this.writeValues(info.getValues());
                    this.writeLink(info.getLinks());
                    w.write("</INFO>");
                    continue;
                }
                w.write("/>");
            }
        }
    }

    public void writeField(FieldSet fieldSet) throws IOException {
        Writer w = this.bw;
        int len = fieldSet.getItemCount();
        for (int i = 0; i < len; ++i) {
            SavotField field = (SavotField)fieldSet.getItemAt(i);
            this.writeComment(field.getAbove());
            w.write("\n<FIELD");
            if (field.getName().length() != 0) {
                w.append(" name=\"").append(this.encodeAttribute(field.getName())).append('\"');
            }
            if (field.getId().length() != 0) {
                w.append(" ID=\"").append(this.encodeAttribute(field.getId())).append('\"');
            }
            if (field.getDataType().length() != 0) {
                w.append(" datatype=\"").append(this.encodeAttribute(field.getDataType())).append('\"');
            }
            if (field.getArraySize().length() != 0) {
                w.append(" arraysize=\"").append(this.encodeAttribute(field.getArraySize())).append('\"');
            }
            if (field.getPrecision().length() != 0) {
                w.append(" precision=\"").append(this.encodeAttribute(field.getPrecision())).append('\"');
            }
            if (field.getWidth().length() != 0) {
                w.append(" width=\"").append(this.encodeAttribute(field.getWidth())).append('\"');
            }
            if (field.getXtype().length() != 0) {
                w.append(" xtype=\"").append(this.encodeAttribute(field.getXtype())).append('\"');
            }
            if (field.getRef().length() != 0) {
                w.append(" ref=\"").append(this.encodeAttribute(field.getRef())).append('\"');
            }
            if (field.getUcd().length() != 0) {
                w.append(" ucd=\"").append(this.encodeAttribute(field.getUcd())).append('\"');
            }
            if (field.getUtype().length() != 0) {
                w.append(" utype=\"").append(this.encodeAttribute(field.getUtype())).append('\"');
            }
            if (field.getType().length() != 0) {
                w.append(" type=\"").append(this.encodeAttribute(field.getType())).append('\"');
            }
            if (field.getUnit().length() != 0) {
                w.append(" unit=\"").append(this.encodeAttribute(field.getUnit())).append('\"');
            }
            if (field.getDescription().length() != 0 || field.getValues() != null || field.getLinks().getItemCount() != 0) {
                w.write(">");
                this.writeComment(field.getBelow());
                this.writeDescription(field.getDescription());
                this.writeValues(field.getValues());
                this.writeLink(field.getLinks());
                w.write(fieldend);
                continue;
            }
            w.write("/>");
        }
    }

    public void writeFieldRef(FieldRefSet fieldRefSet) throws IOException {
        Writer w = this.bw;
        int len = fieldRefSet.getItemCount();
        for (int i = 0; i < len; ++i) {
            SavotFieldRef fieldref = (SavotFieldRef)fieldRefSet.getItemAt(i);
            this.writeComment(fieldref.getAbove());
            w.write("\n<FIELDref");
            if (fieldref.getRef().length() != 0) {
                w.append(" ref=\"").append(this.encodeAttribute(fieldref.getRef())).append('\"');
            }
            if (fieldref.getUcd().length() != 0) {
                w.append(" ucd=\"").append(this.encodeAttribute(fieldref.getUcd())).append('\"');
            }
            if (fieldref.getUtype().length() != 0) {
                w.append(" utype=\"").append(this.encodeAttribute(fieldref.getUtype())).append('\"');
            }
            w.write("/>");
        }
    }

    public void writeStream(SavotStream stream) throws IOException {
        Writer w = this.bw;
        this.writeComment(stream.getAbove());
        w.write("\n<STREAM");
        if (stream.getType().length() != 0) {
            w.append(" type=\"").append(this.encodeAttribute(stream.getType())).append('\"');
        }
        if (stream.getHref().length() != 0) {
            w.append(" href=\"").append(this.encodeAttribute(stream.getHref())).append('\"');
        }
        if (stream.getActuate().length() != 0) {
            w.append(" actuate=\"").append(this.encodeAttribute(stream.getActuate())).append('\"');
        }
        if (stream.getEncoding().length() != 0) {
            w.append(" encoding=\"").append(this.encodeAttribute(stream.getEncoding())).append('\"');
        }
        if (stream.getExpires().length() != 0) {
            w.append(" expires=\"").append(this.encodeAttribute(stream.getExpires())).append('\"');
        }
        if (stream.getRights().length() != 0) {
            w.append(" rights=\"").append(this.encodeAttribute(stream.getRights())).append('\"');
        }
        w.write(">");
        this.writeComment(stream.getBelow());
        if (stream.getContent().length() != 0) {
            w.write(stream.getContent());
        }
        w.write(streamend);
    }

    public void writeBinary(SavotBinary binary) throws IOException {
        if (binary.getStream() != null) {
            Writer w = this.bw;
            this.writeComment(binary.getAbove());
            w.write(binarybegin);
            this.writeComment(binary.getBelow());
            this.writeStream(binary.getStream());
            w.write(binaryend);
        }
    }

    public void writeValues(SavotValues values) throws IOException {
        if (values != null) {
            Writer w = this.bw;
            this.writeComment(values.getAbove());
            w.write("\n<VALUES");
            if (values.getId().length() != 0) {
                w.append(" ID=\"").append(this.encodeAttribute(values.getId())).append('\"');
            }
            if (values.getType().length() != 0) {
                w.append(" type=\"").append(this.encodeAttribute(values.getType())).append('\"');
            }
            if (values.getNull().length() != 0) {
                w.append(" null=\"").append(this.encodeAttribute(values.getNull())).append('\"');
            }
            if (values.getRef().length() != 0) {
                w.append(" ref=\"").append(this.encodeAttribute(values.getRef())).append('\"');
            }
            if (values.getInvalid().length() != 0) {
                w.append(" invalid=\"").append(this.encodeAttribute(values.getInvalid())).append('\"');
            }
            w.write(">");
            this.writeComment(values.getBelow());
            if (values.getMin() != null) {
                SavotMin min = values.getMin();
                this.writeMin(min);
            }
            if (values.getMax() != null) {
                SavotMax max = values.getMax();
                this.writeMax(max);
            }
            this.writeOption(values.getOptions());
            w.write(valuesend);
        }
    }

    public void writeFits(SavotFits fits) throws IOException {
        Writer w = this.bw;
        this.writeComment(fits.getAbove());
        w.write("\n<FITS");
        if (fits.getExtnum().length() != 0) {
            w.append(" extnum=\"").append(this.encodeAttribute(fits.getExtnum())).append('\"');
        }
        w.write(">");
        this.writeComment(fits.getBelow());
        if (fits.getStream() != null) {
            this.writeStream(fits.getStream());
        }
        w.write(fitsend);
    }

    public void writeMin(SavotMin min) throws IOException {
        Writer w = this.bw;
        this.writeComment(min.getAbove());
        w.write("\n<MIN");
        if (min.getValue().length() != 0) {
            w.append(" value=\"").append(this.encodeAttribute(min.getValue())).append('\"');
        }
        if (min.getInclusive().length() != 0) {
            w.append(" inclusive=\"").append(this.encodeAttribute(min.getInclusive())).append('\"');
        }
        if (min.getContent().length() != 0) {
            w.write(">");
            this.writeComment(min.getBelow());
            w.write(min.getContent());
            w.write(minend);
        } else {
            w.write("/>");
            this.writeComment(min.getBelow());
        }
    }

    public void writeMax(SavotMax max) throws IOException {
        Writer w = this.bw;
        this.writeComment(max.getAbove());
        w.write("\n<MAX");
        if (max.getValue().length() != 0) {
            w.append(" value=\"").append(this.encodeAttribute(max.getValue())).append('\"');
        }
        if (max.getInclusive().length() != 0) {
            w.append(" inclusive=\"").append(this.encodeAttribute(max.getInclusive())).append('\"');
        }
        if (max.getContent().length() != 0) {
            w.write(">");
            this.writeComment(max.getBelow());
            w.write(max.getContent());
            w.write(maxend);
        } else {
            w.write("/>");
            this.writeComment(max.getBelow());
        }
    }

    public void writeOption(OptionSet optionSet) throws IOException {
        Writer w = this.bw;
        int len = optionSet.getItemCount();
        for (int i = 0; i < len; ++i) {
            SavotOption option = (SavotOption)optionSet.getItemAt(i);
            this.writeComment(option.getAbove());
            w.write("\n<OPTION");
            if (option.getName().length() != 0) {
                w.append(" name=\"").append(this.encodeAttribute(option.getName())).append('\"');
            }
            if (option.getValue().length() != 0) {
                w.append(" value=\"").append(this.encodeAttribute(option.getValue())).append('\"');
            }
            if (option.getOptions().getItemCount() != 0) {
                w.write(">");
                this.writeComment(option.getBelow());
                this.writeOption(option.getOptions());
                w.write(optionend);
                continue;
            }
            w.write("/>");
            this.writeComment(option.getBelow());
        }
    }

    public void writeGroup(GroupSet groupSet) throws IOException {
        Writer w = this.bw;
        int len = groupSet.getItemCount();
        for (int i = 0; i < len; ++i) {
            SavotGroup group = (SavotGroup)groupSet.getItemAt(i);
            this.writeComment(group.getAbove());
            w.write("\n<GROUP");
            if (group.getId().length() != 0) {
                w.append(" ID=\"").append(this.encodeAttribute(group.getId())).append('\"');
            }
            if (group.getName().length() != 0) {
                w.append(" name=\"").append(this.encodeAttribute(group.getName())).append('\"');
            }
            if (group.getRef().length() != 0) {
                w.append(" ref=\"").append(this.encodeAttribute(group.getRef())).append('\"');
            }
            if (group.getUcd().length() != 0) {
                w.append(" ucd=\"").append(this.encodeAttribute(group.getUcd())).append('\"');
            }
            if (group.getUtype().length() != 0) {
                w.append(" utype=\"").append(this.encodeAttribute(group.getUtype())).append('\"');
            }
            w.write(">");
            this.writeComment(group.getBelow());
            this.writeDescription(group.getDescription());
            this.writeFieldRef(group.getFieldsRef());
            this.writeParamRef(group.getParamsRef());
            this.writeParam(group.getParams());
            this.writeGroup(group.getGroups());
            w.write(groupend);
        }
    }

    public void writeTableBegin(SavotTable table) throws IOException {
        Writer w = this.bw;
        this.writeComment(table.getAbove());
        w.write("\n<TABLE");
        if (table.getId().length() != 0) {
            w.append(" ID=\"").append(this.encodeAttribute(table.getId())).append('\"');
        }
        if (table.getName().length() != 0) {
            w.append(" name=\"").append(this.encodeAttribute(table.getName())).append('\"');
        }
        if (table.getRef().length() != 0) {
            w.append(" ref=\"").append(this.encodeAttribute(table.getRef())).append('\"');
        }
        if (table.getUcd().length() != 0) {
            w.append(" ucd=\"").append(this.encodeAttribute(table.getUcd())).append('\"');
        }
        if (table.getUtype().length() != 0) {
            w.append(" utype=\"").append(this.encodeAttribute(table.getUtype())).append('\"');
        }
        if (table.getNrows().length() != 0) {
            w.append(" nrows=\"").append(this.encodeAttribute(table.getNrows())).append('\"');
        }
        w.write(">");
        this.writeComment(table.getBelow());
        this.writeDescription(table.getDescription());
    }

    public void writeTableEnd() throws IOException {
        this.bw.write(tableend);
    }

    public void writeResourceBegin(SavotResource resource) throws IOException {
        Writer w = this.bw;
        this.writeComment(resource.getAbove());
        w.write("\n<RESOURCE");
        if (resource.getName().length() != 0) {
            w.append(" name=\"").append(this.encodeAttribute(resource.getName())).append('\"');
        }
        if (resource.getId().length() != 0) {
            w.append(" ID=\"").append(this.encodeAttribute(resource.getId())).append('\"');
        }
        if (resource.getUtype().length() != 0) {
            w.append(" utype=\"").append(this.encodeAttribute(resource.getUtype())).append('\"');
        }
        if (resource.getType().length() != 0) {
            w.append(" type=\"").append(this.encodeAttribute(resource.getType())).append('\"');
        }
        w.write(">");
        this.writeComment(resource.getBelow());
        this.writeDescription(resource.getDescription());
    }

    public void writeResourceEnd() throws IOException {
        this.bw.write(resourceend);
    }

    public void writeTableDataBegin() throws IOException {
        this.bw.write(tabledatabegin);
    }

    public void writeTableDataEnd() throws IOException {
        this.bw.write(tabledataend);
    }

    public void writeDataBegin() throws IOException {
        this.bw.write(databegin);
    }

    public void writeDataEnd() throws IOException {
        this.bw.write(dataend);
    }

    public void writeTR(SavotTR tr) throws IOException {
        Writer w = this.bw;
        boolean doEncode = this.elementEntities;
        w.write(trbegin);
        List tds = tr.getTDSet().getItems();
        int tdLen = tds.size();
        for (int i = 0; i < tdLen; ++i) {
            SavotTD td = (SavotTD)tds.get(i);
            String v = td.getRawContent();
            if (v != null) {
                w.write(tdbegin);
                w.write(doEncode ? this.encodeElement(v) : v);
                w.write(tdend);
                continue;
            }
            w.write(tdempty);
        }
        w.write(trend);
    }

    public void writeResource(ResourceSet resourceset) throws IOException {
        if (resourceset != null) {
            int len = resourceset.getItemCount();
            for (int i = 0; i < len; ++i) {
                SavotResource resource = (SavotResource)resourceset.getItemAt(i);
                this.writeResourceBegin(resource);
                this.writeInfo(resource.getInfos());
                this.writeCoosys(resource.getCoosys());
                this.writeGroup(resource.getGroups());
                this.writeParam(resource.getParams());
                this.writeLink(resource.getLinks());
                TableSet tableSet = resource.getTables();
                int tableLen = tableSet.getItemCount();
                for (int j = 0; j < tableLen; ++j) {
                    SavotTable table = (SavotTable)tableSet.getItemAt(j);
                    this.writeTableBegin(table);
                    this.writeField(table.getFields());
                    this.writeParam(table.getParams());
                    this.writeGroup(table.getGroups());
                    this.writeLink(table.getLinks());
                    SavotData data = table.getData();
                    if (data != null) {
                        this.writeDataBegin();
                        SavotTableData tableData = data.getTableData();
                        if (tableData != null) {
                            this.writeTableDataBegin();
                            TRSet trs = tableData.getTRs();
                            int trLen = trs.getItemCount();
                            for (int r = 0; r < trLen; ++r) {
                                this.writeTR((SavotTR)trs.getItemAt(r));
                            }
                            this.writeTableDataEnd();
                        }
                        if (data.getBinary() != null) {
                            this.writeBinary(data.getBinary());
                        }
                        if (data.getFits() != null) {
                            this.writeFits(data.getFits());
                        }
                        this.writeDataEnd();
                    }
                    this.writeInfo(table.getInfosAtEnd());
                    this.writeTableEnd();
                }
                this.writeResource(resource.getResources());
                this.writeInfo(resource.getInfosAtEnd());
                this.writeResourceEnd();
            }
        }
    }
}

